package com.agilex.healthcare.directscheduling.mdws.connection;


public class MdwsConfigurationHelper {
	private static final String CDW_SITECODE = "204";

	private final static org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(MdwsConfigurationHelper.class);

	public String extractSiteCodeFromAssigningAuthority(String assigningAuthority) {
		String siteCode = "";
		String siteType = "";

		if ("ICN".equalsIgnoreCase(assigningAuthority)) {
			siteCode = CDW_SITECODE;
		} else if (assigningAuthority == null) {
			logger.error("Cannot extract SiteCode from a null assigningAuthority");
		} else {
			int length = assigningAuthority.length();
			if (length == 7) {
				siteType = assigningAuthority.substring(0, 3);
				if (siteType.equalsIgnoreCase("DFN")) {
					siteCode = assigningAuthority.substring(length - 3, length);
				} else {
					logger.error("Cannot extract SiteCode");
				}
			}
		}

		return siteCode;
	}

	public String extractSiteTypeFromAssigningAuthority(String assigningAuthority) {

		if (assigningAuthority.equalsIgnoreCase("ICN"))
			return MdwsDataSourceCode.CDW;
		else
			return MdwsDataSourceCode.VISTA;

	}

}
